package astrology.findyourfate.com;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;

public class Util {
	 private static boolean debugMode = false;
	 private static String tag = "";
	    private static final String CHANGE_FLAG = "__CHANGE";
	    public static Bitmap decodeBitmap(String path, int maxSize) {
	        File f = new File(path);
	        Bitmap b = null;
	        try {
	            //Decode image size
	            BitmapFactory.Options o = new BitmapFactory.Options();
	            o.inJustDecodeBounds = true;

	            FileInputStream fis = new FileInputStream(f);
	            BitmapFactory.decodeStream(fis, null, o);
	            fis.close();

	            int scale = 1;
	            if (o.outHeight > maxSize || o.outWidth > maxSize) {
	                scale = (int) Math.pow(2, (int) Math.round(Math.log(maxSize / (double) Math.max(o.outHeight, o.outWidth)) / Math.log(0.5)));
	            }

	            //Decode with inSampleSize
	            BitmapFactory.Options o2 = new BitmapFactory.Options();
	            o2.inSampleSize = scale;
	            fis = new FileInputStream(f);
	            b = BitmapFactory.decodeStream(fis, null, o2);
	            fis.close();
	        } catch (IOException e) {
	            e.printStackTrace();
	        }
	        return b;
	    }

	public static byte[] bitmapToBytes(Bitmap bitmap) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 80, bout);
        return bout.toByteArray();
    }

	public static void debug(String message) {
        if (debugMode) {
            Log.d(tag, message);
        }
    }

}
